/************************************************************************
    Value_Added_API.h

	revision 1.3 2015-08-13 millieen
	@ Added Get & Set display Language function

	revision 1.2  2015-04-07  CSJ
	@ Change R_WRITE_SD_FAILED to R_WRITE_ISO_FAILED
	@ Added function instruction format

	revision 1.1  2015-04-07  CSJ
	@ Rename function name & data types

	version 1.0  2014-07-24  millieen
	@ Added UniToken Drive storage function
************************************************************************/
#ifndef _UMD_VALUE_ADDED_API_H_
#define _UMD_VALUE_ADDED_API_H_

#ifndef _UMD_RV_
#define _UMD_RV_
typedef unsigned long UMD_RV; 
#endif

#ifndef _UMD_HANDLE_
#define _UMD_HANDLE_
typedef unsigned long UMD_HANDLE;
#endif

#ifndef _UMD_LANGUAGE_
#define _UMD_LANGUAGE_
#define LANGUAGE_ENGLISH       0
#define LANGUAGE_CHINESE       1
#define LANGUAGE_JAPANESE      2
#endif

#ifdef __cplusplus
extern "C" {
#endif

UMD_RV UMD_Initialize();

UMD_RV UMD_Finalize();

/* Function: initialize & find current devices' list
   Parameters:
             lpHandle:   [in] buffer area size. suggest 128(max device count founded one time)
                         [out] return handle list.
             deviceCount:[out] device count founded.
   Return Value: 
             Always R_OK
 */
UMD_RV UMD_Find(UMD_HANDLE* lpHandle, unsigned long* deviceCount);

/* Function: Set a ISO image to CD Partition. Admin logged in needed.
   Parameters:
             handle:    [in] handle of the target device
             fileName:  [in] full path of the ISO image file
   Return Value: 
             R_OK: successed
             R_ARGUMENTS_BAD: invalid ISO file.
             R_IMAGEFILE_TOO_BIG: ISO file size is out of the capacity of CD Partition
			 R_ERASE_CD_FAILED: erase failed. maybe not logged in
			 R_WRITE_ISO_FAILED: write failed.
 */
UMD_RV UMD_WriteISO(UMD_HANDLE handle, char* fileName);

/* Function: Admin log in. default admin pin is "00000000"(8 zeros)
   Parameters:
             handle:           [in] handle of the target device
             pAdminPin:        [in] admin pin
			 uiPinLen:         [in] admin pin length
			 lpCurrentAttempt: [out] attempts left
   Return Value: 
             R_OK: successed
             R_ADMIN_LOGIN_FAILED: log failed.
             R_CANCEL_ADMIN_LOGIN: press cancel button to cancel log.
 */
UMD_RV UMD_AdminLogin(UMD_HANDLE handle, unsigned char* pAdminPin, unsigned int uiPinLen, unsigned long* lpCurrentAttempt);

/* Function: Get current display language
   Parameters:
             handle:    [in]  handle of the target device
             language:  [out] current display language. Could be LANGUAGE_ENGLISH / LANGUAGE_CHINESE / LANGUAGE_JAPANESE
   Return Value: 
             R_OK: successed
             R_UNKNOW_ERROR: get failed.
 */
UMD_RV UMD_GetLanguage(UMD_HANDLE handle, unsigned long* language);

/* Function: Set current display language
   Parameters:
             handle:    [in] handle of the target device
             language:  [in] set display language. Could be LANGUAGE_ENGLISH / LANGUAGE_CHINESE / LANGUAGE_JAPANESE
   Return Value: 
             R_OK: successed
             R_UNKNOW_ERROR: get failed.
 */
UMD_RV UMD_SetLanguage(UMD_HANDLE handle, unsigned long language);

/* Function: Callback function. return the current process.
   Parameters:
             Type:     the type of current operation
             position: the process of current operation permillage (0~1000)
 */
#define STATUS_WRITEISO			0xa01
typedef int (* CALLBACKFUNC)(unsigned long Type, unsigned long position);
extern CALLBACKFUNC pfnCallback;	

#ifdef __cplusplus
}
#endif

//ERR CODE
#define R_SUCCESS							0x00
#define R_NO_DEVICE						0x01
#define R_ARGUMENTS_BAD					0x02
#define R_TIME_OUT						0x03
#define R_UNKNOW_ERROR					0x04
#define R_CHECK_SUM_ERROR				0x05
#define R_IMAGEFILE_TOO_BIG				0x06
#define R_VOLUMELETTER_BLANK			0x07
#define R_WRITE_ISO_FAILED				0x08
#define R_ERASE_CD_FAILED				0x09
#define R_CANCEL_ADMIN_LOGIN			0X0A
#define R_ADMIN_LOGIN_FAILED			0x0B
#define R_ADMIN_PIN_LOCKED				0X0C

#endif // _UMD_VALUE_ADDED_API_H_
